IF EXISTS (SELECT * FROM SYS.procedures WHERE NAME = 'P_GERA_MOV_CAIXA_SAP')
BEGIN
	DROP PROCEDURE P_GERA_MOV_CAIXA_SAP
END

GO

/****** Object:  StoredProcedure [dbo].[P_GERA_MOV_CAIXA_SAP]    Script Date: 30/08/2016 16:43:09 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- P_GERA_MOV_CAIXA_SAP 1, 29, '20160820','20160820',0 
CREATE PROCEDURE [dbo].[P_GERA_MOV_CAIXA_SAP](@CD_EMP    INT,
												@CD_FILIAL VARCHAR(MAX),
												@DT_INI    DATETIME,
												@DT_FIN    DATETIME,
												@BLOQUEADO INT = 0)

/*********************************************************************************************************************/
--CDIGOS DO DE/PARA
--TABELA: GLB_DEPARA
--CAMPO: TP_REG
--	VALOR:
--		PARA VALORES DE 1 A 7, O DE/PARA SE REFERE AO CAMPO COD_MODALIDADE, QUE  CDIGO DA MODALIDADE NO SAP, COMO MOSTRADO ABAIXO
--		1 - MODALIDADE DINHEIRO					- CAMPO DE RETORNO: COD_MODALIDADE
--		2 - MODALIDADE CHEQUE A VISTA			- CAMPO DE RETORNO: COD_MODALIDADE
--		3 - MODALIDADE CHEQUE A PRAZO			- CAMPO DE RETORNO: COD_MODALIDADE
--		4 - MODALIDADE CARTO					- CAMPO DE RETORNO: COD_MODALIDADE
--		5 - MODALIDADE CONVNIO					- CAMPO DE RETORNO: COD_MODALIDADE
--		6 - MODALIDADE CONVNIO PBM				- CAMPO DE RETORNO: COD_MODALIDADE
--		7 - MODALIDADE NCC						- CAMPO DE RETORNO: COD_MODALIDADE
--		PARA VALORES DE 8 A 10, O DE/PARA SE REFERE AO CAMPO CD_CLI, QUE  CDIGO DO CLIENTE NO SAP, COMO MOSTRADO ABAIXO
--		8  - TIPO DE REGISTRO REFERENTE AOS CDIGOS DE CLIENTES SAP PARA AS MODALIDADES DE DINHEIRO, CHEQUE A VISTA E CHEQUE A PRAZO. CAMPO DE RETORNO: CD_CLI.
--		9  - TIPO DE REGISTRO REFERENTE AOS CDIGOS DE CLIENTES SAP PARA AS MODALIDADES DE CARTO DE CRDITO E DBITO. CAMPO DE RETORNO: CD_CLI.
--		10 - TIPO DE REGISTRO REFERENTE AOS CDIGOS DE CLIENTES SAP PARA AS MODALIDADES DE CONVNIO E CONVNIO PBM. CAMPO DE RETORNO: CD_CLI.
/*********************************************************************************************************************/
AS
	BEGIN
			SET NOCOUNT ON;
			SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

			Print ' Inicio da rotina movimento SAP - ' + Convert(varchar,getdate(),108)
			CREATE TABLE #RS_RETORNO
				(
					 --CAMPOS DO HEADER
					 CD_FILIAL             INT,
					 CNPJ_FIL              VARCHAR(100),
					 CD_EMPRESA_CONTABIL   VARCHAR(100),
					 CD_FILIAL_EXPORTA     VARCHAR(100),
					 CD_ADM_CARTAO         INT,
					 DT_EMIS               DATETIME,
					 COD_MODALIDADE        VARCHAR(100),
					 DESC_MODALIDADE       VARCHAR(100),
					 VALOR                 MONEY,
					 NUMERO_ID_DEPOSITO    VARCHAR(100),
					 CD_CLI                VARCHAR(100),
					 CNPJ_CLI              VARCHAR(50),
					 DT_MOV                DATETIME,
					 VLR_TAXA_ADM          MONEY,
					 VLR_MONTANTE_ORIGINAL MONEY,
					 VLR_TROCA_POSITIVO    MONEY,
					 VLR_TROCA_NEGATIVO    MONEY,
					 --CAMPOS DO DETALHAMENTO
					 VLR_TOT_CUPOM         MONEY,
					 VLR_TAXA_ADM_CUPOM    MONEY,
					 NR_ECF                INT,
					 NR_AUTORIZACAO_ADM    VARCHAR(100),
					 NR_NSU                VARCHAR(100),
					 NR_POS_VD             VARCHAR(100),
					 NR_CHEQUE_VD          VARCHAR(100),
					 CGC_CPF               VARCHAR(50),--QUANDO CHEQUE, CPF DO EMISSOR. QUANDO CONVNIO, CNPJ DO CONVENIADO
					 DT_DEPOS_CHQ          DATETIME
				)

			CREATE TABLE #PRC_FILIAL_TMP
				(
					 CD_FILIAL INT NOT NULL PRIMARY KEY
				)

			INSERT INTO #PRC_FILIAL_TMP
			SELECT
				ID
			FROM
				UFD_PRM_IN_STRING(@CD_FILIAL)

/********************************************************************************************************************/
--DINHEIRO		
/********************************************************************************************************************/
			Print ' Insere o movimento de dinheiro - ' + Convert(varchar,getdate(),108)

			INSERT INTO #RS_RETORNO
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                AS CD_FILIAL_EXPORTA
				,0                                                           AS CD_ADM_CARTAO
				,GETDATE()                                                   AS DT_EMIS
				,COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'DINHEIRO'                                                  AS MODALIDADE
				,FECHA.VLR_DINH                                              AS VALOR
				,''                                                          AS NUMERO_ID_DEPOSITO
				,''                                                          AS CD_CLI
				,--PARA CLIENTE NO  NECESSRIO ENVIAR O CDIGO DE CLIENTE
				''                                                           AS CNPJ
				,FECHA.DT_MOV
				,0                                                           AS VLR_TOT_TAXA
				,0                                                           AS VLR_MONTANTE_ORIGINAL
				,0                                                           AS VLR_TROCA_POSITIVO
				,0                                                           AS VLR_TROCA_NEGATIVO
				,VD.VLR_DINH                                                 AS VLR_TOT_CUPOM
				,0                                                           AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF
				,''                                                          AS NR_AUTORIZACAO_ADM
				,''                                                          AS NR_NSU
				,''                                                          AS NR_POS_VD
				,''                                                          AS NR_CHEQUE_VD
				,''                                                          AS CGC_CPF
				,''                                                          AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 1 AND
					DEPARA_MOD.PK_REG = 1
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0 AND
				VD.VLR_DINH  > 0
/********************************************************************************************************************/
--CHEQUE  VISTA			
/********************************************************************************************************************/
			
			Print ' Insere o movimento de Cheque a vista  - ' + Convert(varchar,getdate(),108)
			INSERT INTO #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                AS CD_FILIAL_EXPORTA
				,0                                                           AS CD_ADM_CARTAO
				,GETDATE()                                                   AS DT_EMIS
				,COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'CHEQUE A VISTA'                                            AS MODALIDADE
				,FECHA.VLR_CHQ_VISTA                                         AS VALOR
				,''                                                          AS NUMERO_ID_DEPOSITO
				,COALESCE(CAST(DEPARA_CLI.FK_REG AS VARCHAR(100)), 'NAODEF') AS CD_CLI
				,''                                                          AS CNPJ_CLI
				,FECHA.DT_MOV
				,0                                                           AS VLR_TAXA_ADM
				,0                                                           AS VLR_MONTANTE_ORIGINAL
				,0                                                           AS VLR_TROCA_POSITIVO
				,0                                                           AS VLR_TROCA_NEGATIVO
				,CHQS.VLR_CHQ                                                AS VLR_TOT_CUPOM
				,0                                                           AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF                                                   AS NR_ECF
				,''                                                          AS NR_AUTORIZACAO_ADM
				,''                                                          AS NR_NSU
				,''                                                          AS NR_POS_VD
				,RIGHT('000' + CAST(CHQS.CD_BC_CHQ AS VARCHAR), 3)
				 + RIGHT('00000' + CAST(CHQS.AG_CHQ AS VARCHAR), 5)
				 + RIGHT('00000000000' + CAST(CHQS.NR_CNT_CHQ AS VARCHAR), 11)
				 + RIGHT('000000' + CAST(CHQS.NR_CHQ AS VARCHAR), 6)         AS NR_CHEQUE_VD
				,RIGHT(CHQ_EMI.CGC_CPF, 15)                                  AS CGC_CPF
				,FECHA_CHQ.DT_VENCTO                                         AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PDV_VD_CHQS_CHQ_LANC VINC_CHQS ON
					VD.CD_EMP = VINC_CHQS.CD_EMP AND
					VD.CD_FILIAL = VINC_CHQS.CD_FILIAL AND
					VD.CD_VD = VINC_CHQS.CD_VD
				INNER JOIN PDV_VD_FECHA_MOV_CHQ_LANC_CPL FECHA_CHQ ON
					FECHA.CD_EMP = FECHA_CHQ.CD_EMP AND
					FECHA.CD_FILIAL = FECHA_CHQ.CD_FILIAL AND
					FECHA.DT_MOV = FECHA_CHQ.DT_MOV AND
					VINC_CHQS.CD_CHQ = FECHA_CHQ.CD_CHQ
				INNER JOIN CHQ_LANC_CPL CHQS ON
					VINC_CHQS.CD_EMP = CHQS.CD_EMP AND
					VINC_CHQS.CD_CHQ = CHQS.CD_CHQ
				INNER JOIN CHQ_EMI ON
					CHQS.CD_EMP = CHQ_EMI.CD_EMP AND
					CHQS.CD_EMI = CHQ_EMI.CD_EMI
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 2 AND
					DEPARA_MOD.PK_REG = 2
				LEFT JOIN GLB_DEPARA DEPARA_CLI ON
					DEPARA_MOD.TP_REG = 8 AND
					DEPARA_MOD.PK_REG = 2
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0 AND
				VD.VLR_CHQS  > 0 AND
				VD.DT_VD     = FECHA_CHQ.DT_VENCTO
/********************************************************************************************************************/
--CHEQUE  PRAZO
/********************************************************************************************************************/
			
			Print ' Insere o movimento de Cheque a prazo - ' + Convert(varchar,getdate(),108)
			INSERT INTO #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                AS CD_FILIAL_EXPORTA
				,0                                                           AS CD_ADM_CARTAO
				,GETDATE()                                                   AS DT_EMIS
				,COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'CHEQUE A PRAZO'                                            AS MODALIDADE
				,FECHA.VLR_CHQ_PRZ                                           AS VALOR
				,''                                                          AS NUMERO_ID_DEPOSITO
				,COALESCE(CAST(DEPARA_CLI.FK_REG AS VARCHAR(100)), 'NAODEF') AS CD_CLI
				,''                                                          AS CNPJ_CLI
				,FECHA.DT_MOV
				,0                                                           AS VLR_TAXA_ADM
				,0                                                           AS VLR_MONTANTE_ORIGINAL
				,0                                                           AS VLR_TROCA_POSITIVO
				,0                                                           AS VLR_TROCA_NEGATIVO
				,CHQS.VLR_CHQ                                                AS VLR_TOT_CUPOM
				,0                                                           AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF                                                   AS NR_ECF
				,''                                                          AS NR_AUTORIZACAO_ADM
				,''                                                          AS NR_NSU
				,''                                                          AS NR_POS_VD
				,RIGHT('000' + CAST(CHQS.CD_BC_CHQ AS VARCHAR), 3)
				 + RIGHT('00000' + CAST(CHQS.AG_CHQ AS VARCHAR), 5)
				 + RIGHT('00000000000' + CAST(CHQS.NR_CNT_CHQ AS VARCHAR), 11)
				 + RIGHT('000000' + CAST(CHQS.NR_CHQ AS VARCHAR), 6)         AS NR_CHEQUE_VD
				,RIGHT(CHQ_EMI.CGC_CPF, 15)                                  AS CGC_CPF
				,FECHA_CHQ.DT_VENCTO                                         AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PDV_VD_CHQS_CHQ_LANC VINC_CHQS ON
					VD.CD_EMP = VINC_CHQS.CD_EMP AND
					VD.CD_FILIAL = VINC_CHQS.CD_FILIAL AND
					VD.CD_VD = VINC_CHQS.CD_VD
				INNER JOIN PDV_VD_FECHA_MOV_CHQ_LANC_CPL FECHA_CHQ ON
					FECHA.CD_EMP = FECHA_CHQ.CD_EMP AND
					FECHA.CD_FILIAL = FECHA_CHQ.CD_FILIAL AND
					FECHA.DT_MOV = FECHA_CHQ.DT_MOV AND
					VINC_CHQS.CD_CHQ = FECHA_CHQ.CD_CHQ
				INNER JOIN CHQ_LANC_CPL CHQS ON
					VINC_CHQS.CD_EMP = CHQS.CD_EMP AND
					VINC_CHQS.CD_CHQ = CHQS.CD_CHQ
				INNER JOIN CHQ_EMI ON
					CHQS.CD_EMP = CHQ_EMI.CD_EMP AND
					CHQS.CD_EMI = CHQ_EMI.CD_EMI
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 3 AND
					DEPARA_MOD.PK_REG = 3
				LEFT JOIN GLB_DEPARA DEPARA_CLI ON
					DEPARA_MOD.TP_REG = 8 AND
					DEPARA_MOD.PK_REG = 3
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0 AND
				VD.VLR_CHQS  > 0 AND
				VD.DT_VD     <> FECHA_CHQ.DT_VENCTO

/********************************************************************************************************************/
--CARTO DE CRDITO
/********************************************************************************************************************/
			Print ' Insere o movimento de Cartao credito - ' + Convert(varchar,getdate(),108)
			INSERT INTO #RS_RETORNO 
			SELECT
				FIL.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                                             AS CD_FILIAL_EXPORTA
				,VD_TEF.CD_ADM_CARTAO
				,GETDATE()                                                                                AS DT_EMIS
				,
				--COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)),'NAODEF') AS COD_MODALIDADE,
				CASE WHEN VD_TEF.VL_CARTAO = 0 THEN 'A40D'
				 ELSE COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF')
				 END                                                                                      AS COD_MODALIDADE
				,LEFT(RC_ADM_CARTAO.NM_USUAL, 25)                                                         AS MODALIDADE
				,
				--dbo.UFD_RETORNA_TOTAL_CARTAO_CREDITO_SAP (FIL.CD_FILIAL,FECHA.DT_MOV,COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)),'NAODEF')) AS VALOR,
				COALESCE(dbo.UFD_RETORNA_TOTAL_CARTAO_CREDITO_SAP (FIL.CD_FILIAL, FECHA.DT_MOV, CASE WHEN VD_TEF.VL_CARTAO = 0 THEN 'A40D'
																																												 ELSE COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF')
																																												 END), 0) AS VALOR
				,CAST(RC_ADM_CARTAO.TP_ADM AS VARCHAR(100))                                               AS NUMERO_ID_DEPOSITO
				,COALESCE(CAST(DEPARA_CLI.FK_REG AS VARCHAR(100)), 'NAODEF')                              AS CD_CLI
				,''                                                                                       AS CNPJ_CLI
				,FECHA.DT_MOV
				,CASE WHEN ISNULL(GRP_TAXAS.TP_TAXA, 0) = 0 THEN dbo.UFD_RETORNA_TOTAL_CARTAO_CREDITO_SAP (FIL.CD_FILIAL, FECHA.DT_MOV, COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF')) * ISNULL(GRP_TAXAS.PERC_TAXA, 0) / 100
				 ELSE ISNULL(GRP_TAXAS.PERC_TAXA, 0)
				 END                                                                                      AS VLR_TOT_TAXA
				,0                                                                                        AS VLR_MONTANTE_ORIGINAL
				,0                                                                                        AS VLR_TROCA_POSITIVO
				,0                                                                                        AS VLR_TROCA_NEGATIVO
				,VD_TEF.VL_CARTAO
				,VD_TEF.VL_CARTAO * ISNULL(GRP_TAXAS.PERC_TAXA, 0) / 100                                  AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF                                                                                AS NR_ECF
				,CAST(VD_TEF.NR_AUTORIZACAO AS VARCHAR(100))                                              AS NR_AUTORIZACAO
				,VD_TEF.NSU_SITEF                                                                         AS NR_NSU
				,CX.ID_TERM_TEF                                                                           AS NR_POS_VD
				,''                                                                                       AS NR_CHEQUE_VD
				,''                                                                                       AS CGC_CPF
				,''                                                                                       AS DT_DEPOS_CHQ
			FROM
				PDV_VD VD
				
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					VD.CD_FILIAL = FECHA.CD_FILIAL AND
					VD.CD_EMP	= FECHA.CD_EMP AND
					VD.CD_FILIAL= FECHA.CD_FILIAL AND
					VD.DT_VD	= FECHA.DT_MOV

				INNER JOIN PDV_VD_FECHA_RC_ADM_CARTAO_CREDITO F ON
					FECHA.CD_EMP = F.CD_EMP AND
					FECHA.CD_FILIAL = F.CD_FILIAL AND
					FECHA.DT_MOV = F.DT_MOV 

				INNER JOIN PDV_CX CX ON
					VD.CD_EMP	 = CX.CD_EMP AND
					VD.CD_FILIAL = CX.CD_FILIAL AND
					VD.CD_CX	 = CX.CD_CX

				INNER JOIN PDV_VD_TEF VD_TEF ON
					VD.CD_EMP	 = VD_TEF.CD_EMP AND
					VD.CD_FILIAL = VD_TEF.CD_FILIAL AND
					VD.CD_VD	 = VD_TEF.CD_VD AND
					F.CD_ADM_CARTAO = VD_TEF.CD_ADM_CARTAO

				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				INNER JOIN PRC_GRP_ECON_PRC_FILIAL GRP_FIL ON
					FIL.CD_EMP = GRP_FIL.CD_EMP AND
					FIL.CD_FILIAL = GRP_FIL.CD_FILIAL
				LEFT JOIN RC_ADM_CARTAO_PRC_GRP_ECON_TAXAS GRP_TAXAS ON
					GRP_FIL.CD_EMP = GRP_TAXAS.CD_EMP AND
					GRP_FIL.CD_GRP_ECON = GRP_TAXAS.CD_GRP_ECON AND
					VD_TEF.CD_ADM_CARTAO = GRP_TAXAS.CD_ADM_CARTAO
				INNER JOIN RC_ADM_CARTAO ON
					F.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
					F.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 4 AND
					F.CD_ADM_CARTAO = DEPARA_MOD.PK_REG
				LEFT JOIN GLB_DEPARA DEPARA_CLI ON
					DEPARA_CLI.TP_REG = 9 AND
					F.CD_ADM_CARTAO = DEPARA_CLI.PK_REG
			WHERE
				VD.CD_EMP = @CD_EMP AND
				VD.DT_VD BETWEEN @DT_INI AND @DT_FIN AND
				VD.CD_FILIAL IN ( SELECT CD_FILIAL FROM #PRC_FILIAL_TMP) AND 
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0;

/********************************************************************************************************************/
--CARTO DE DBITO
/********************************************************************************************************************/
			Print ' Insere o movimento de Cartao debito - ' + Convert(varchar,getdate(),108);
			INSERT INTO #RS_RETORNO 
			SELECT
				FIL.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                               AS CD_FILIAL
				,VD_TEF.CD_ADM_CARTAO
				,GETDATE()                                                                  AS DT_EMIS
				,CASE WHEN VD_TEF.VL_CARTAO = 0 THEN 'A39D'
				 ELSE COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF')
				 END                                                                        AS COD_MODALIDADE
				,LEFT(RC_ADM_CARTAO.NM_USUAL, 25)                                           AS MODALIDADE
				,dbo.UFD_RETORNA_TOTAL_CARTAO_DEBITO_SAP (FIL.CD_FILIAL, FECHA.DT_MOV, CASE WHEN VD_TEF.VL_CARTAO = 0 THEN 'A39D'
																																							 ELSE COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF')
																																							 END) AS VALOR
				,CAST(RC_ADM_CARTAO.TP_ADM AS VARCHAR(100))                                 AS NUMERO_ID_DEPOSITO
				,COALESCE(CAST(DEPARA_CLI.FK_REG AS VARCHAR(100)), 'NAODEF')                AS CD_CLI
				,''                                                                         AS CNPJ_CLI
				,FECHA.DT_MOV
				,CASE WHEN ISNULL(GRP_TAXAS.TP_TAXA, 0) = 0 THEN dbo.UFD_RETORNA_TOTAL_CARTAO_DEBITO_SAP (FIL.CD_FILIAL, FECHA.DT_MOV, COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF')) * ISNULL(GRP_TAXAS.PERC_TAXA, 0) / 100
				 ELSE ISNULL(GRP_TAXAS.PERC_TAXA, 0)
				 END                                                                        AS VLR_TOT_TAXA
				,0                                                                          AS VLR_MONTANTE_ORIGINAL
				,0                                                                          AS VLR_TROCA_POSITIVO
				,0                                                                          AS VLR_TROCA_NEGATIVO
				,VD_TEF.VL_CARTAO
				,VD_TEF.VL_CARTAO * ISNULL(GRP_TAXAS.PERC_TAXA, 0) / 100                    AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF                                                                  AS NR_ECF
				,CAST(VD_TEF.NR_AUTORIZACAO AS VARCHAR(100))                                AS NR_AUTORIZACAO
				,VD_TEF.NSU_SITEF                                                           AS NR_NSU
				,CX.ID_TERM_TEF                                                             AS NR_POS_VD
				,''                                                                         AS NR_CHEQUE_VD
				,''                                                                         AS CGC_CPF
				,''                                                                         AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO F ON
					FECHA.CD_EMP = F.CD_EMP AND
					FECHA.CD_FILIAL = F.CD_FILIAL AND
					FECHA.DT_MOV = F.DT_MOV
				INNER JOIN PDV_VD VD ON
					FECHA.CD_EMP = VD.CD_EMP AND
					FECHA.CD_FILIAL = VD.CD_FILIAL AND
					FECHA.DT_MOV = VD.DT_VD
				INNER JOIN PDV_CX CX ON
					VD.CD_EMP = CX.CD_EMP AND
					VD.CD_FILIAL = CX.CD_FILIAL AND
					VD.CD_CX = CX.CD_CX
				INNER JOIN PDV_VD_TEF VD_TEF ON
					VD.CD_EMP = VD_TEF.CD_EMP AND
					VD.CD_FILIAL = VD_TEF.CD_FILIAL AND
					VD.CD_VD = VD_TEF.CD_VD AND
					F.CD_ADM_CARTAO = VD_TEF.CD_ADM_CARTAO
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				INNER JOIN PRC_GRP_ECON_PRC_FILIAL GRP_FIL ON
					FIL.CD_EMP = GRP_FIL.CD_EMP AND
					FIL.CD_FILIAL = GRP_FIL.CD_FILIAL
				LEFT JOIN RC_ADM_CARTAO_PRC_GRP_ECON_TAXAS GRP_TAXAS ON
					GRP_FIL.CD_EMP = GRP_TAXAS.CD_EMP AND
					GRP_FIL.CD_GRP_ECON = GRP_TAXAS.CD_GRP_ECON AND
					F.CD_ADM_CARTAO = GRP_TAXAS.CD_ADM_CARTAO
				INNER JOIN RC_ADM_CARTAO ON
					F.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
					F.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 4 AND
					F.CD_ADM_CARTAO = DEPARA_MOD.PK_REG
				LEFT JOIN GLB_DEPARA DEPARA_CLI ON
					DEPARA_CLI.TP_REG = 9 AND
					F.CD_ADM_CARTAO = DEPARA_CLI.PK_REG
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0

/********************************************************************************************************************/
--CONVNIO
/********************************************************************************************************************/
			Print ' Insere o movimento de Convenio - ' + Convert(varchar,getdate(),108);
			INSERT INTO #RS_RETORNO
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                AS CD_FILIAL
				,0                                                           AS CD_ADM_CARTAO
				,GETDATE()                                                   AS DT_EMIS
				,COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'CONVENIO'                                                  AS MODALIDADE
				,RC_VD_CONV.VLR_CONV                                         AS VALOR
				,''                                                          AS NUMERO_ID_DEPOSITO
				,
				--COALESCE(DEPARA_CLI.FK_REG,'NAODEF') AS CD_CLI,
				CAST(CONV.CD_CLI AS VARCHAR(100))                            AS CD_CLI
				,CONV.CGC_CPF                                                AS CNPJ
				,FECHA.DT_MOV
				,0                                                           AS VLR_TOT_TAXA
				,0                                                           AS VLR_MONTANTE_ORIGINAL
				,0                                                           AS VLR_TROCA_POSITIVO
				,0                                                           AS VLR_TROCA_NEGATIVO
				,VD_CONV_VD.VLR_CONV                                         AS VLR_TOT_CUPOM
				,0                                                           AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF
				,''                                                          AS NR_AUTORIZACAO_ADM
				,''                                                          AS NR_NSU
				,''                                                          AS NR_POS_VD
				,''                                                          AS NR_CHEQUE_VD
				,CLI.CGC_CPF                                                 AS CGC_CPF
				,''                                                          AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PDV_VD_RC_VD_CONV VD_CONV ON
					VD.CD_EMP = VD_CONV.CD_EMP AND
					VD.CD_FILIAL = VD_CONV.CD_FILIAL AND
					VD.CD_VD = VD_CONV.CD_VD
				INNER JOIN (SELECT
											RC_VD_CONV.CD_EMP
											,RC_VD_CONV.CD_FILIAL
											,RC_VD_CONV.DT_VD
											,RC_VD_CONV.CD_CONV
											,SUM(RC_VD_CONV.VLR_CONV) AS VLR_CONV
										FROM
											RC_VD_CONV
											INNER JOIN PDV_VD_RC_VD_CONV ON
												RC_VD_CONV.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP AND
												RC_VD_CONV.CD_CTR = PDV_VD_RC_VD_CONV.CD_CTR
											INNER JOIN PDV_VD ON
												PDV_VD_RC_VD_CONV.CD_EMP = PDV_VD.CD_EMP AND
												PDV_VD_RC_VD_CONV.CD_FILIAL = PDV_VD.CD_FILIAL AND
												PDV_VD_RC_VD_CONV.CD_VD = PDV_VD.CD_VD
										WHERE
										 PDV_VD.ST_VD = 0
										GROUP  BY
										 RC_VD_CONV.CD_EMP
										 ,RC_VD_CONV.CD_FILIAL
										 ,RC_VD_CONV.DT_VD
										 ,RC_VD_CONV.CD_CONV) RC_VD_CONV ON
					VD_CONV.CD_EMP = RC_VD_CONV.CD_EMP AND
					VD_CONV.CD_FILIAL = RC_VD_CONV.CD_FILIAL AND
					VD.DT_VD = RC_VD_CONV.DT_VD
				INNER JOIN RC_VD_CONV VD_CONV_VD ON
					VD_CONV.CD_EMP = VD_CONV_VD.CD_EMP AND
					VD_CONV.CD_FILIAL = VD_CONV_VD.CD_FILIAL AND
					VD_CONV.CD_CTR = VD_CONV_VD.CD_CTR AND
					RC_VD_CONV.CD_CONV = VD_CONV_VD.CD_CONV
				INNER JOIN RC_CLI_CONV_VINC_RC_CLI ON
					RC_VD_CONV.CD_EMP = RC_CLI_CONV_VINC_RC_CLI.CD_EMP AND
					RC_VD_CONV.CD_CONV = RC_CLI_CONV_VINC_RC_CLI.CD_CONV
				INNER JOIN RC_CLI CONV ON
					RC_CLI_CONV_VINC_RC_CLI.CD_EMP = CONV.CD_EMP AND
					RC_CLI_CONV_VINC_RC_CLI.CD_CLI = CONV.CD_CLI
				INNER JOIN RC_CLI CLI ON
					VD_CONV_VD.CD_EMP = CLI.CD_EMP AND
					VD_CONV_VD.CD_CLI = CLI.CD_CLI
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 5 AND
					VD_CONV_VD.CD_CONV = DEPARA_MOD.PK_REG
				LEFT JOIN GLB_DEPARA DEPARA_CLI ON
					DEPARA_MOD.TP_REG = 10 AND
					CONV.CD_CLI = DEPARA_CLI.PK_REG
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0 AND
				VD.VLR_CONV  > 0


/********************************************************************************************************************/
--CONVNIO PBM
/********************************************************************************************************************/
			Print ' Insere o movimento de Convenio PBM - ' + Convert(varchar,getdate(),108);
			INSERT INTO #RS_RETORNO
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                AS CD_FILIAL
				,0                                                           AS CD_ADM_CARTAO
				,GETDATE()                                                   AS DT_EMIS
				,COALESCE(CAST(DEPARA_MOD.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'CONVENIO PBM'                                              AS MODALIDADE
				,IT_PBM.VLR_PBM                                              AS VALOR
				,''                                                          AS NUMERO_ID_DEPOSITO
				,COALESCE(CAST(DEPARA_CLI.FK_REG AS VARCHAR(100)), 'NAODEF') AS CD_CLI
				,COALESCE(CAST(RC_CLI.CGC_CPF AS VARCHAR(100)), 'NAODEF')    AS CNPJ
				,FECHA.DT_MOV
				,0                                                           AS VLR_TOT_TAXA
				,0                                                           AS VLR_MONTANTE_ORIGINAL
				,0                                                           AS VLR_TROCA_POSITIVO
				,0                                                           AS VLR_TROCA_NEGATIVO
				,VD.VLR_CONV_PBM                                             AS VLR_TOT_CUPOM
				,0                                                           AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF
				,''                                                          AS NR_AUTORIZACAO_ADM
				,''                                                          AS NR_NSU
				,''                                                          AS NR_POS_VD
				,''                                                          AS NR_CHEQUE_VD
				,COALESCE(CAST(RC_CLI.CGC_CPF AS VARCHAR(100)), 'NAODEF')    AS CGC_CPF
				,''                                                          AS DT_DEPOS_CHQ
			FROM

				PDV_VD VD
				INNER JOIN PDV_CONSLD_VD MR ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL= VD.CD_FILIAL AND
					MR.DT_MOV	= VD.DT_VD AND
					MR.CD_CX	= VD.CD_CX 
				
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_EMP	= MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV	= MR.DT_MOV 
					
				
				INNER JOIN (SELECT
									VD.CD_EMP
									,VD.CD_FILIAL
									,VD.DT_VD
									,VD.CD_CLI_PBM
									,SUM(VD.VLR_CONV_PBM) AS VLR_PBM
								FROM
									PDV_VD VD
								WHERE
									ST_VD = 0 AND
									CD_EMP    = @CD_EMP AND
									DT_VD BETWEEN @DT_INI AND @DT_FIN AND
									CD_FILIAL IN (SELECT CD_FILIAL FROM #PRC_FILIAL_TMP FT) 
								GROUP  BY
									VD.CD_EMP
									,VD.CD_FILIAL
									,VD.DT_VD
									,VD.CD_CLI_PBM) IT_PBM ON
					VD.CD_EMP    = IT_PBM.CD_EMP AND
					VD.CD_FILIAL = IT_PBM.CD_FILIAL AND
					VD.DT_VD	 = IT_PBM.DT_VD AND
					VD.CD_CLI_PBM = IT_PBM.CD_CLI_PBM

				LEFT JOIN RC_CLI ON
					VD.CD_EMP = RC_CLI.CD_EMP AND
					VD.CD_CLI_PBM = RC_CLI.CD_CLI

				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL

				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA_MOD ON
					DEPARA_MOD.TP_REG = 6 AND
					RC_CLI.CD_CLI = DEPARA_MOD.PK_REG
				LEFT JOIN GLB_DEPARA DEPARA_CLI ON
					DEPARA_MOD.TP_REG = 10 AND
					RC_CLI.CD_CLI = DEPARA_CLI.PK_REG
			WHERE
				VD.CD_EMP    = @CD_EMP AND
				VD.DT_VD BETWEEN @DT_INI AND @DT_FIN AND
				VD.CD_FILIAL IN (SELECT CD_FILIAL FROM #PRC_FILIAL_TMP FT) AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD        = 0 AND
				VD.VLR_CONV_PBM > 0
 
/********************************************************************************************************************/
--NCC - VENDA COM NCC VINCULADA - NAO CONVENIO
/********************************************************************************************************************/
			Print ' Insere o movimento de NCC sem Convenio - ' + Convert(varchar,getdate(),108);
			INSERT INTO #RS_RETORNO			
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                            AS CD_FILIAL
				,0                                                       AS CD_ADM_CARTAO
				,GETDATE()                                               AS DT_EMIS
				,COALESCE(CAST(DEPARA.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'DEVOLUCAO'                                             AS MODALIDADE
				,NCC_RESUMO.VLR_NCC                                      AS VALOR
				,''                                                      AS NUMERO_ID_DEPOSITO
				,''                                                      AS CD_CLI
				,''                                                      AS CNPJ
				,FECHA.DT_MOV
				,0                                                       AS VLR_TOT_TAXA
				,0                                                       AS VLR_MONTANTE_ORIGINAL
				,0                                                       AS VLR_TROCA_POSITIVO
				,0                                                       AS VLR_TROCA_NEGATIVO
				,NCC.VLR_NCC                                             AS VLR_TOT_CUPOM
				,0                                                       AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF                                               AS NR_ECF
				,CAST(MAX(ENT.NR_NF) AS VARCHAR(100))                    AS NR_AUTORIZACAO_ADM
				,''                                                      AS NR_DOC_REG_ADM
				,''                                                      AS NR_POS_VD
				,''                                                      AS NR_CHEQUE_VD
				,''                                                      AS CGC_CPF
				,''                                                      AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PDV_VD_DEV_NCC_PDV_VD NCC_VD ON
					VD.CD_EMP = NCC_VD.CD_EMP AND
					VD.CD_FILIAL = NCC_VD.CD_FILIAL AND
					VD.CD_VD = NCC_VD.CD_VD
				INNER JOIN PDV_VD_DEV_NCC NCC ON
					NCC_VD.CD_EMP = NCC.CD_EMP AND
					NCC_VD.CD_FILIAL = NCC.CD_FILIAL AND
					NCC_VD.CD_CTR_NCC = NCC.CD_CTR_NCC
				LEFT JOIN PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP VINC_DEV ON
					NCC.CD_CTR_NCC = VINC_DEV.CD_CTR_NCC AND
					NCC.CD_EMP = VINC_DEV.CD_EMP AND
					NCC.CD_FILIAL = VINC_DEV.CD_FILIAL
				LEFT JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT VINC_ENT ON
					VINC_DEV.CD_EMP = VINC_ENT.CD_EMP AND
					VINC_DEV.CD_FILIAL = VINC_ENT.CD_FILIAL AND
					VINC_DEV.CD_VD = VINC_ENT.CD_VD AND
					VINC_DEV.CD_IMP = VINC_ENT.CD_IMP AND
					VINC_DEV.CD_PROD = VINC_ENT.CD_PROD AND
					VINC_DEV.CD_IT = VINC_ENT.CD_IT
				LEFT JOIN EST_NF_ENT ENT ON
					VINC_ENT.CD_EMP = ENT.CD_EMP AND
					VINC_ENT.CD_FILIAL = ENT.CD_FILIAL AND
					VINC_ENT.CD_NF = ENT.CD_NF
				INNER JOIN (SELECT
											NCC.CD_EMP
											,NCC.CD_FILIAL
											,VD.DT_VD
											,SUM(NCC.VLR_NCC) AS VLR_NCC
										FROM
											PDV_VD VD
											INNER JOIN PDV_VD_DEV_NCC_PDV_VD NCC_VD ON
												VD.CD_EMP = NCC_VD.CD_EMP AND
												VD.CD_FILIAL = NCC_VD.CD_FILIAL AND
												VD.CD_VD = NCC_VD.CD_VD
											INNER JOIN PDV_VD_DEV_NCC NCC ON
												NCC_VD.CD_EMP = NCC.CD_EMP AND
												NCC_VD.CD_FILIAL = NCC.CD_FILIAL AND
												NCC_VD.CD_CTR_NCC = NCC.CD_CTR_NCC
										WHERE
										 VD.ST_VD = 0
										GROUP  BY
										 NCC.CD_EMP
										 ,NCC.CD_FILIAL
										 ,VD.DT_VD) NCC_RESUMO ON
					VD.CD_EMP = NCC_RESUMO.CD_EMP AND
					VD.CD_FILIAL = NCC_RESUMO.CD_FILIAL AND
					VD.DT_VD = NCC_RESUMO.DT_VD
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA ON
					DEPARA.TP_REG = 7 AND
					DEPARA.PK_REG = 7
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0 AND
				VD.VLR_CONV  = 0
			GROUP  BY
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL
				,COALESCE(CAST(DEPARA.FK_REG AS VARCHAR(100)), 'NAODEF')
				,NCC_RESUMO.VLR_NCC
				,FECHA.DT_MOV
				,NCC.VLR_NCC
				,VD.NR_ECF

/********************************************************************************************************************/
--NCC - VENDA COM NCC VINCULADA - NAO CONVENIO
/********************************************************************************************************************/
			Print ' Insere o movimento de venda com NCC nao convenio - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                            AS CD_FILIAL
				,0                                                       AS CD_ADM_CARTAO
				,GETDATE()                                               AS DT_EMIS
				,COALESCE(CAST(DEPARA.FK_REG AS VARCHAR(100)), 'NAODEF') AS COD_MODALIDADE
				,'DEVOLUCAO'                                             AS MODALIDADE
				,NCC_RESUMO.VLR_NCC                                      AS VALOR
				,''                                                      AS NUMERO_ID_DEPOSITO
				,''                                                      AS CD_CLI
				,''                                                      AS CNPJ
				,FECHA.DT_MOV
				,0                                                       AS VLR_TOT_TAXA
				,0                                                       AS VLR_MONTANTE_ORIGINAL
				,0                                                       AS VLR_TROCA_POSITIVO
				,0                                                       AS VLR_TROCA_NEGATIVO
				,NCC.VLR_NCC                                             AS VLR_TOT_CUPOM
				,0                                                       AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF                                               AS NR_ECF
				,CAST(MAX(ENT.NR_NF) AS VARCHAR(100))                    AS NR_AUTORIZACAO_ADM
				,''                                                      AS NR_DOC_REG_ADM
				,''                                                      AS NR_POS_VD
				,''                                                      AS NR_CHEQUE_VD
				,''                                                      AS CGC_CPF
				,''                                                      AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PDV_VD_DEV_NCC_PDV_VD NCC_VD ON
					VD.CD_EMP = NCC_VD.CD_EMP AND
					VD.CD_FILIAL = NCC_VD.CD_FILIAL AND
					VD.CD_VD = NCC_VD.CD_VD
				INNER JOIN PDV_VD_DEV_NCC NCC ON
					NCC_VD.CD_EMP = NCC.CD_EMP AND
					NCC_VD.CD_FILIAL = NCC.CD_FILIAL AND
					NCC_VD.CD_CTR_NCC = NCC.CD_CTR_NCC
				LEFT JOIN PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP VINC_DEV ON
					NCC.CD_CTR_NCC = VINC_DEV.CD_CTR_NCC AND
					NCC.CD_EMP = VINC_DEV.CD_EMP AND
					NCC.CD_FILIAL = VINC_DEV.CD_FILIAL
				LEFT JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT VINC_ENT ON
					VINC_DEV.CD_EMP = VINC_ENT.CD_EMP AND
					VINC_DEV.CD_FILIAL = VINC_ENT.CD_FILIAL AND
					VINC_DEV.CD_VD = VINC_ENT.CD_VD AND
					VINC_DEV.CD_IMP = VINC_ENT.CD_IMP AND
					VINC_DEV.CD_PROD = VINC_ENT.CD_PROD AND
					VINC_DEV.CD_IT = VINC_ENT.CD_IT
				LEFT JOIN EST_NF_ENT ENT ON
					VINC_ENT.CD_EMP = ENT.CD_EMP AND
					VINC_ENT.CD_FILIAL = ENT.CD_FILIAL AND
					VINC_ENT.CD_NF = ENT.CD_NF
				INNER JOIN (SELECT
											NCC.CD_EMP
											,NCC.CD_FILIAL
											,VD.DT_VD
											,SUM(NCC.VLR_NCC) AS VLR_NCC
										FROM
											PDV_VD VD
											INNER JOIN PDV_VD_DEV_NCC_PDV_VD NCC_VD ON
												VD.CD_EMP = NCC_VD.CD_EMP AND
												VD.CD_FILIAL = NCC_VD.CD_FILIAL AND
												VD.CD_VD = NCC_VD.CD_VD
											INNER JOIN PDV_VD_DEV_NCC NCC ON
												NCC_VD.CD_EMP = NCC.CD_EMP AND
												NCC_VD.CD_FILIAL = NCC.CD_FILIAL AND
												NCC_VD.CD_CTR_NCC = NCC.CD_CTR_NCC
										WHERE
										 VD.ST_VD = 0
										GROUP  BY
										 NCC.CD_EMP
										 ,NCC.CD_FILIAL
										 ,VD.DT_VD) NCC_RESUMO ON
					VD.CD_EMP = NCC_RESUMO.CD_EMP AND
					VD.CD_FILIAL = NCC_RESUMO.CD_FILIAL AND
					VD.DT_VD = NCC_RESUMO.DT_VD
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN GLB_DEPARA DEPARA ON
					DEPARA.TP_REG = 7 AND
					DEPARA.PK_REG = 8
			WHERE
				FECHA.CD_EMP    = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD        = 0 AND
				VD.VLR_CONV     > 0 AND
				VD.VLR_DINH     = 0 AND
				VD.VLR_CARTAO   = 0 AND
				VD.VLR_CONV_PBM = 0
			GROUP  BY
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL
				,COALESCE(CAST(DEPARA.FK_REG AS VARCHAR(100)), 'NAODEF')
				,NCC_RESUMO.VLR_NCC
				,FECHA.DT_MOV
				,NCC.VLR_NCC
				,VD.NR_ECF

/********************************************************************************************************************/
-- NCC AMORTIZADA
/********************************************************************************************************************/
			Print ' Insere o movimento de NCC amortizada - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL         AS CD_FILIAL
				,0                                    AS CD_ADM_CARTAO
				,GETDATE()                            AS DT_EMIS
				,'B35D'                               AS COD_MODALIDADE
				,'DEV AMORTIZADA'                     AS MODALIDADE
				,NCC_RESUMO.VLR_NCC                   AS VALOR
				,''                                   AS NUMERO_ID_DEPOSITO
				,''                                   AS CD_CLI
				,''                                   AS CNPJ
				,FECHA.DT_MOV
				,0                                    AS VLR_TOT_TAXA
				,0                                    AS VLR_MONTANTE_ORIGINAL
				,0                                    AS VLR_TROCA_POSITIVO
				,0                                    AS VLR_TROCA_NEGATIVO
				,NCC.VLR_NCC                          AS VLR_TOT_CUPOM
				,0                                    AS VLR_TAXA_ADM_CUPOM
				,NCC.CD_CTR_NCC                       AS NR_ECF
				,CAST(MAX(ENT.NR_NF) AS VARCHAR(100)) NR_AUTORIZACAO_ADM
				,''                                   AS NR_DOC_REG_ADM
				,''                                   AS NR_POS_VD
				,''                                   AS NR_CHEQUE_VD
				,''                                   AS CGC_CPF
				,''                                   AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_VD_DEV_NCC NCC ON
					FECHA.CD_EMP = NCC.CD_EMP AND
					FECHA.CD_FILIAL = NCC.CD_FILIAL AND
					FECHA.DT_MOV = NCC.DT_CAD
				LEFT JOIN PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP VINC_DEV ON
					NCC.CD_CTR_NCC = VINC_DEV.CD_CTR_NCC AND
					NCC.CD_EMP = VINC_DEV.CD_EMP AND
					NCC.CD_FILIAL = VINC_DEV.CD_FILIAL
				LEFT JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT VINC_ENT ON
					VINC_DEV.CD_EMP = VINC_ENT.CD_EMP AND
					VINC_DEV.CD_FILIAL = VINC_ENT.CD_FILIAL AND
					VINC_DEV.CD_VD = VINC_ENT.CD_VD AND
					VINC_DEV.CD_IMP = VINC_ENT.CD_IMP AND
					VINC_DEV.CD_PROD = VINC_ENT.CD_PROD AND
					VINC_DEV.CD_IT = VINC_ENT.CD_IT
				LEFT JOIN EST_NF_ENT ENT ON
					VINC_ENT.CD_EMP = ENT.CD_EMP AND
					VINC_ENT.CD_FILIAL = ENT.CD_FILIAL AND
					VINC_ENT.CD_NF = ENT.CD_NF
				INNER JOIN (SELECT
											NCC.CD_EMP
											,NCC.CD_FILIAL
											,NCC.DT_CAD
											,SUM(NCC.VLR_NCC) AS VLR_NCC
										FROM
											PDV_VD_DEV_NCC NCC
										WHERE
										 NCC.STS_NCC IN( 2, 3 )
										GROUP  BY
										 NCC.CD_EMP
										 ,NCC.CD_FILIAL
										 ,NCC.DT_CAD) NCC_RESUMO ON
					FECHA.CD_EMP = NCC_RESUMO.CD_EMP AND
					FECHA.CD_FILIAL = NCC_RESUMO.CD_FILIAL AND
					FECHA.DT_MOV = NCC_RESUMO.DT_CAD
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 )
				-- SOMENTE NCC'S AMORTIZADAS(CANCELADAS)
				AND
				NCC.STS_NCC IN( 2, 3 )
			GROUP  BY
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL
				,NCC_RESUMO.VLR_NCC
				,FECHA.DT_MOV
				,NCC.VLR_NCC
				,NCC.CD_CTR_NCC


/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - SALDO INICIAL
/********************************************************************************************************************/
			--Print ' Insere o movimento de Saldo inicial - ' + Convert(varchar,getdate(),108);
			--INSERT INTO 
			--	#RS_RETORNO
			--SELECT
			--	fil.CD_FILIAL,
			--	FIL.CGC,
			--	FIL.CD_EMPRESA_CONTABIL,
			--	FIL.CD_CENTRO_CUSTO_CONTABIL AS CD_FILIAL,
			--	0 AS CD_ADM_CARTAO,
			--	GETDATE() AS DT_EMIS,
			--	'N01D' AS COD_MODALIDADE,
			--	'SALDO INICIAL' AS MODALIDADE,
			--	FECHA.VLR_SLD_INI AS VALOR,
			--	'' AS NUMERO_ID_DEPOSITO,
			--	'' AS CD_CLI,
			--	'' AS CNPJ,
			--	FECHA.DT_MOV, 
			--	0 AS VLR_TOT_TAXA,
			--	0 AS VLR_MONTANTE_ORIGINAL,
			--	0 AS VLR_TROCA_POSITIVO,
			--	0 AS VLR_TROCA_NEGATIVO,
			--	FECHA.VLR_SLD_INI AS VLR_TOT_CUPOM,
			--	0 AS VLR_TAXA_ADM_CUPOM,
			--	0 AS NR_ECF,
			--	'' AS NR_AUTORIZACAO_ADM,
			--	'' AS NR_DOC_REG_ADM,
			--	'' AS NR_POS_VD,
			--	'' AS NR_CHEQUE_VD,
			--	'' AS CGC_CPF,
			--	'' AS DT_DEPOS_CHQ
			--FROM
			--	PDV_VD_FECHA_MOV FECHA
			--	INNER JOIN PRC_FILIAL FIL ON
			--		FECHA.CD_EMP = FIL.CD_EMP
			--		AND FECHA.CD_FILIAL = FIL.CD_FILIAL
			--	INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
			--		FIL.CD_EMP = FIL_BAND.CD_EMP
			--		AND FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
			--	INNER JOIN PRC_BANDEIRA BAND ON
			--		FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
			--WHERE
			--	FECHA.CD_EMP = @CD_EMP
			--	AND FECHA.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))
			--	AND FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN
			--	AND FECHA.BLQ_ALT_FECHA IN (0,1);

			
/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - FUNDO DE TROCO
/********************************************************************************************************************/
			Print ' Insere o movimento de fundo de troco - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL AS CD_FILIAL
				,0                            AS CD_ADM_CARTAO
				,GETDATE()                    AS DT_EMIS
				,'N02D'                       AS COD_MODALIDADE
				,'FUNDO TROCO'                AS MODALIDADE
				,FECHA.VLR_FUNDO_TROCO        AS VALOR
				,''                           AS NUMERO_ID_DEPOSITO
				,''                           AS CD_CLI
				,''                           AS CNPJ
				,FECHA.DT_MOV
				,0                            AS VLR_TOT_TAXA
				,0                            AS VLR_MONTANTE_ORIGINAL
				,0                            AS VLR_TROCA_POSITIVO
				,0                            AS VLR_TROCA_NEGATIVO
				,FECHA.VLR_FUNDO_TROCO        AS VLR_TOT_CUPOM
				,0                            AS VLR_TAXA_ADM_CUPOM
				,0                            AS NR_ECF
				,''                           AS NR_AUTORIZACAO_ADM
				,''                           AS NR_DOC_REG_ADM
				,''                           AS NR_POS_VD
				,''                           AS NR_CHEQUE_VD
				,''                           AS CGC_CPF
				,''                           AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 );
			
/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - CARTO PRPRIO
/********************************************************************************************************************/
			Print ' Insere o movimento de cartao proprio - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL AS CD_FILIAL
				,0                            AS CD_ADM_CARTAO
				,GETDATE()                    AS DT_EMIS
				,'N03D'                       AS COD_MODALIDADE
				,'CARTAO PROPRIO'             AS MODALIDADE
				,FECHA.VLR_CARTAO_PROPRIO     AS VALOR
				,''                           AS NUMERO_ID_DEPOSITO
				,''                           AS CD_CLI
				,''                           AS CNPJ
				,FECHA.DT_MOV
				,0                            AS VLR_TOT_TAXA
				,0                            AS VLR_MONTANTE_ORIGINAL
				,0                            AS VLR_TROCA_POSITIVO
				,0                            AS VLR_TROCA_NEGATIVO
				,FECHA.VLR_CARTAO_PROPRIO     AS VLR_TOT_CUPOM
				,0                            AS VLR_TAXA_ADM_CUPOM
				,0                            AS NR_ECF
				,''                           AS NR_AUTORIZACAO_ADM
				,''                           AS NR_DOC_REG_ADM
				,''                           AS NR_POS_VD
				,''                           AS NR_CHEQUE_VD
				,''                           AS CGC_CPF
				,''                           AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 )

/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - DESPESAS
/********************************************************************************************************************/
			Print ' Insere o movimento de despesas - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL AS CD_FILIAL
				,0                            AS CD_ADM_CARTAO
				,GETDATE()                    AS DT_EMIS
				,'N04D'                       AS COD_MODALIDADE
				,'DESPESAS'                   AS MODALIDADE
				,FECHA.VLR_DESP               AS VALOR
				,''                           AS NUMERO_ID_DEPOSITO
				,''                           AS CD_CLI
				,''                           AS CNPJ
				,FECHA.DT_MOV
				,0                            AS VLR_TOT_TAXA
				,0                            AS VLR_MONTANTE_ORIGINAL
				,0                            AS VLR_TROCA_POSITIVO
				,0                            AS VLR_TROCA_NEGATIVO
				,FECHA.VLR_DESP               AS VLR_TOT_CUPOM
				,0                            AS VLR_TAXA_ADM_CUPOM
				,0                            AS NR_ECF
				,''                           AS NR_AUTORIZACAO_ADM
				,''                           AS NR_DOC_REG_ADM
				,''                           AS NR_POS_VD
				,''                           AS NR_CHEQUE_VD
				,''                           AS CGC_CPF
				,''                           AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 );

/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - DINHEIRO REMETIDO
/********************************************************************************************************************/

			Print ' Insere o movimento de dinheiro remetido - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL AS CD_FILIAL
				,0                            AS CD_ADM_CARTAO
				,GETDATE()                    AS DT_EMIS
				,'N05D'                       AS COD_MODALIDADE
				,'DINHEIRO REMETIDO'          AS MODALIDADE
				,FECHA.VLR_DINHEIRO           AS VALOR
				,''                           AS NUMERO_ID_DEPOSITO
				,''                           AS CD_CLI
				,''                           AS CNPJ
				,FECHA.DT_MOV
				,0                            AS VLR_TOT_TAXA
				,0                            AS VLR_MONTANTE_ORIGINAL
				,0                            AS VLR_TROCA_POSITIVO
				,0                            AS VLR_TROCA_NEGATIVO
				,FECHA.VLR_DINHEIRO           AS VLR_TOT_CUPOM
				,0                            AS VLR_TAXA_ADM_CUPOM
				,0                            AS NR_ECF
				,''                           AS NR_AUTORIZACAO_ADM
				,''                           AS NR_DOC_REG_ADM
				,''                           AS NR_POS_VD
				,''                           AS NR_CHEQUE_VD
				,''                           AS CGC_CPF
				,''                           AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 );

	
/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - RECARGA DE CELULAR
/********************************************************************************************************************/
			Print ' Insere o movimento de dinheiro recarga de celular - ' + Convert(varchar,getdate(),108);
			INSERT INTO  #RS_RETORNO
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL   AS CD_FILIAL
				,0                              AS CD_ADM_CARTAO
				,GETDATE()                      AS DT_EMIS
				,'N06D'                         AS COD_MODALIDADE
				,'RECARGA CELULAR'              AS MODALIDADE
				,CNF_RESUMO.VLR_CNF             AS VALOR
				,''                             AS NUMERO_ID_DEPOSITO
				,''                             AS CD_CLI
				,''                             AS CNPJ
				,FECHA.DT_MOV
				,0                              AS VLR_TOT_TAXA
				,0                              AS VLR_MONTANTE_ORIGINAL
				,0                              AS VLR_TROCA_POSITIVO
				,0                              AS VLR_TROCA_NEGATIVO
				,CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS VLR_TOT_CUPOM
				,0                              AS VLR_TAXA_ADM_CUPOM
				,NR_COO                         AS NR_ECF
				,''                             AS NR_AUTORIZACAO_ADM
				,''                             AS NR_DOC_REG_ADM
				,''                             AS NR_POS_VD
				,''                             AS NR_CHEQUE_VD
				,''                             AS CGC_CPF
				,''                             AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				INNER JOIN PDV_CUPOM_NAO_FISCAL CUPOM_NAO_FISCAL ON
					FECHA.CD_EMP = CUPOM_NAO_FISCAL.CD_EMP AND
					FECHA.CD_FILIAL = CUPOM_NAO_FISCAL.CD_FILIAL AND
					FECHA.DT_MOV = CUPOM_NAO_FISCAL.DT_CUPOM
				INNER JOIN (SELECT
											CNF.CD_EMP
											,CNF.CD_FILIAL
											,CNF.DT_CUPOM
											,SUM(CNF.VLR_TOT_CUPOM) AS VLR_CNF
										FROM
											PDV_CUPOM_NAO_FISCAL CNF
										WHERE
										 CNF.TP_CUPOM_NAO_FISCAL = 3
										GROUP  BY
										 CNF.CD_EMP
										 ,CNF.CD_FILIAL
										 ,CNF.DT_CUPOM) CNF_RESUMO ON
					CUPOM_NAO_FISCAL.CD_EMP = CNF_RESUMO.CD_EMP AND
					CUPOM_NAO_FISCAL.CD_FILIAL = CNF_RESUMO.CD_FILIAL AND
					CUPOM_NAO_FISCAL.DT_CUPOM = CNF_RESUMO.DT_CUPOM
			WHERE
				FECHA.CD_EMP                         = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 3

/********************************************************************************************************************/
--MOVIMENTO NUMERRIO - OCORRNCIAS
/********************************************************************************************************************/
			Print ' Insere o movimento de ocorrencias - ' + Convert(varchar,getdate(),108);
			INSERT INTO #RS_RETORNO 
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL                                                                                                                AS CD_FILIAL
				,0                                                                                                                                           AS CD_ADM_CARTAO
				,GETDATE()                                                                                                                                   AS DT_EMIS
				,CASE WHEN ( FECHA.VLR_CARTAO_PROPRIO
								+ FECHA.VLR_SLD_INI + FECHA.VLR_DOACAO
								+ FECHA.VLR_DINH + FECHA.VLR_DINH_OUTRAS_DATA - ( FECHA.VLR_FUNDO_TROCO + FECHA.VLR_DESP
																																	+ FECHA.VLR_NCC_CANCELADA_DINH
																																	+ FECHA.VLR_NCC_AMORTIZADA
																																	+ ISNULL(TRANSP.VLR_DINH_TRANSPORTADO, 0) ) ) - VLR_DINHEIRO >= 0 THEN 'N07D'
				 ELSE 'N08D'
				 END                                                                                                                                         AS COD_MODALIDADE
				,'OCORRENCIAS'                                                                                                                               AS MODALIDADE
				,ABS(( FECHA.VLR_CARTAO_PROPRIO
							 + FECHA.VLR_SLD_INI + FECHA.VLR_DOACAO
							 + FECHA.VLR_DINH + FECHA.VLR_DINH_OUTRAS_DATA - ( FECHA.VLR_FUNDO_TROCO + FECHA.VLR_DESP
																																 + FECHA.VLR_NCC_CANCELADA_DINH
																																 + FECHA.VLR_NCC_AMORTIZADA
																																 + ISNULL(TRANSP.VLR_DINH_TRANSPORTADO, 0) ) ) - VLR_DINHEIRO)                       AS VALOR
				,''                                                                                                                                          AS NUMERO_ID_DEPOSITO
				,''                                                                                                                                          AS CD_CLI
				,''                                                                                                                                          AS CNPJ
				,FECHA.DT_MOV
				,0                                                                                                                                           AS VLR_TOT_TAXA
				,0                                                                                                                                           AS VLR_MONTANTE_ORIGINAL
				,0                                                                                                                                           AS VLR_TROCA_POSITIVO
				,0                                                                                                                                           AS VLR_TROCA_NEGATIVO
				,ABS(( FECHA.VLR_CARTAO_PROPRIO
							 + FECHA.VLR_SLD_INI + FECHA.VLR_DOACAO
							 + FECHA.VLR_DINH + FECHA.VLR_DINH_OUTRAS_DATA - ( FECHA.VLR_FUNDO_TROCO + FECHA.VLR_DESP
																																 + FECHA.VLR_NCC_CANCELADA_DINH
																																 + FECHA.VLR_NCC_AMORTIZADA
																																 + ISNULL(TRANSP.VLR_DINH_TRANSPORTADO, 0) ) ) - VLR_DINHEIRO) / FECHA_OCOR.CONTADOR AS VLR_TOT_CUPOM
				,0                                                                                                                                           AS VLR_TAXA_ADM_CUPOM
				,0                                                                                                                                           AS NR_ECF
				,''                                                                                                                                          AS NR_AUTORIZACAO_ADM
				,''                                                                                                                                          AS NR_DOC_REG_ADM
				,''                                                                                                                                          AS NR_POS_VD
				,''                                                                                                                                          AS NR_CHEQUE_VD
				,''                                                                                                                                          AS CGC_CPF
				,''                                                                                                                                          AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN (SELECT
											CD_EMP
											,CD_FILIAL
											,DT_MOV
											,COUNT(*) AS CONTADOR
										FROM
											PDV_VD_FECHA_MOV_OCORRENCIA
										GROUP  BY
										 CD_EMP
										 ,CD_FILIAL
										 ,DT_MOV) FECHA_OCOR ON
					FECHA.CD_EMP = FECHA_OCOR.CD_EMP AND
					FECHA.CD_FILIAL = FECHA_OCOR.CD_FILIAL AND
					FECHA.DT_MOV = FECHA_OCOR.DT_MOV
				INNER JOIN PDV_VD_FECHA_MOV_OCORRENCIA OCOR ON
					FECHA.CD_EMP = OCOR.CD_EMP AND
					FECHA.CD_FILIAL = OCOR.CD_FILIAL AND
					FECHA.DT_MOV = OCOR.DT_MOV
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN (SELECT
										 PDV_VD.CD_EMP
										 ,PDV_VD.CD_FILIAL
										 ,PDV_VD.DT_VD
										 ,ISNULL(SUM(PDV_VD.VLR_DINH), 0) AS VLR_DINH_TRANSPORTADO
									 FROM
										 TELE_ORC
										 INNER JOIN TELE_ORC_ETAPA ON
											 TELE_ORC.CD_ORC = TELE_ORC_ETAPA.CD_ORC AND
											 TELE_ORC.CD_ORC_ETAPA = TELE_ORC_ETAPA.CD_ORC_ETAPA
										 INNER JOIN TELE_ORC_ETAPA_PDV_VD ON
											 TELE_ORC.CD_ORC = TELE_ORC_ETAPA_PDV_VD.CD_ORC
										 INNER JOIN PDV_VD ON
											 TELE_ORC_ETAPA_PDV_VD.CD_EMP = PDV_VD.CD_EMP AND
											 TELE_ORC_ETAPA_PDV_VD.CD_FILIAL = PDV_VD.CD_FILIAL AND
											 TELE_ORC_ETAPA_PDV_VD.Cd_Vd = PDV_VD.Cd_Vd
										 INNER JOIN RC_CLI ON
											 TELE_ORC.CD_EMP = RC_CLI.CD_EMP AND
											 TELE_ORC.CD_CLI = RC_CLI.CD_CLI
									 WHERE
										TELE_ORC_ETAPA_PDV_VD.DT_FECHA_CAIXA <> PDV_VD.DT_VD AND
										PDV_VD.ST_VD                         = 0
									 GROUP  BY
										PDV_VD.CD_EMP
										,PDV_VD.CD_FILIAL
										,PDV_VD.DT_VD) TRANSP ON
					FECHA.CD_EMP = TRANSP.CD_EMP AND
					FECHA.CD_FILIAL = TRANSP.CD_FILIAL AND
					FECHA.DT_MOV <= TRANSP.DT_VD
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 )

/********************************************************************************************************************/
--DUPLICATA
/********************************************************************************************************************/
			Print ' Insere o movimento de duplicatas - ' + Convert(varchar,getdate(),108);
			INSERT INTO #RS_RETORNO
			SELECT
				fil.CD_FILIAL
				,FIL.CGC
				,FIL.CD_EMPRESA_CONTABIL
				,FIL.CD_CENTRO_CUSTO_CONTABIL        AS CD_FILIAL_EXPORTA
				,0                                   AS CD_ADM_CARTAO
				,GETDATE()                           AS DT_EMIS
				,'B87D'                              AS COD_MODALIDADE
				,'DUPLICATA'                         AS MODALIDADE
				,FECHA.VLR_DUP                       AS VALOR
				,''                                  AS NUMERO_ID_DEPOSITO
				,CAST(CLI_NF.CD_CLI AS VARCHAR(100)) AS CD_CLI
				,--PARA CLIENTE NO  NECESSRIO ENVIAR O CDIGO DE CLIENTE
				CLI_NF.CGC_CPF                       AS CNPJ
				,FECHA.DT_MOV
				,0                                   AS VLR_TOT_TAXA
				,0                                   AS VLR_MONTANTE_ORIGINAL
				,0                                   AS VLR_TROCA_POSITIVO
				,0                                   AS VLR_TROCA_NEGATIVO
				,VD.VLR_DUP                          AS VLR_TOT_CUPOM
				,0                                   AS VLR_TAXA_ADM_CUPOM
				,VD.NR_ECF
				,''                                  AS NR_AUTORIZACAO_ADM
				,''                                  AS NR_NSU
				,''                                  AS NR_POS_VD
				,''                                  AS NR_CHEQUE_VD
				,''                                  AS CGC_CPF
				,''                                  AS DT_DEPOS_CHQ
			FROM
				#PRC_FILIAL_TMP FT
				INNER JOIN PDV_VD_FECHA_MOV FECHA ON
					FECHA.CD_FILIAL = FT.CD_FILIAL
				INNER JOIN PDV_CONSLD_VD MR ON
					FECHA.CD_EMP = MR.CD_EMP AND
					FECHA.CD_FILIAL = MR.CD_FILIAL AND
					FECHA.DT_MOV = MR.DT_MOV
				INNER JOIN PDV_VD VD ON
					MR.CD_EMP = VD.CD_EMP AND
					MR.CD_FILIAL = VD.CD_FILIAL AND
					MR.DT_MOV = VD.DT_VD AND
					MR.CD_CX = VD.CD_CX
				INNER JOIN PRC_FILIAL FIL ON
					FECHA.CD_EMP = FIL.CD_EMP AND
					FECHA.CD_FILIAL = FIL.CD_FILIAL
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL_BAND ON
					FIL.CD_EMP = FIL_BAND.CD_EMP AND
					FIL.CD_FILIAL = FIL_BAND.CD_FILIAL
				INNER JOIN PRC_BANDEIRA BAND ON
					FIL_BAND.CD_BANDEIRA = BAND.CD_BANDEIRA
				LEFT JOIN PDV_VD_EST_NF_SAI VD_NF ON
					VD.CD_EMP = VD_NF.CD_EMP AND
					VD.CD_FILIAL = VD_NF.CD_FILIAL AND
					VD.CD_VD = VD_NF.CD_VD
				LEFT JOIN EST_NF_SAI NF ON
					VD_NF.CD_EMP = NF.CD_EMP AND
					VD_NF.CD_FILIAL = NF.CD_FILIAL AND
					VD_NF.CD_NF = NF.CD_NF
				LEFT JOIN RC_CLI CLI_NF ON
					VD.CD_EMP = CLI_NF.CD_EMP AND
					VD.CD_CLI = CLI_NF.CD_CLI
			WHERE
				FECHA.CD_EMP = @CD_EMP AND
				FECHA.DT_MOV BETWEEN @DT_INI AND @DT_FIN AND
				FECHA.BLQ_ALT_FECHA IN ( 0, 1 ) AND
				VD.ST_VD     = 0 AND
				VD.VLR_DUP   > 0

			DROP TABLE #PRC_FILIAL_TMP;

			Print ' Fim da rotina, devolve o resultado - ' + Convert(varchar,getdate(),108);
			SET NOCOUNT OFF;
			SELECT
				*
			FROM
				#RS_RETORNO
			ORDER  BY
				CD_FILIAL
				,DT_MOV
				,COD_MODALIDADE
				,CD_CLI
				,CD_ADM_CARTAO
			SET NOCOUNT ON;
			DROP TABLE #RS_RETORNO;
			RETURN
	END

GO 
